﻿:Namespace Locks
    ⍝ Client functions for the Locks Server
    ⍝ Init (address port user), then call Lock & Release

    (⎕IO ⎕ML ⎕WX)←1 0 3

    ∇ r←Lock token
      ⍝ Lock Token using Lock Daemon
      r←_Do LOCKSERVER('CltLock'token)
    ∇

    ∇ r←Release token
      ⍝ Release token using Lock Daemon
      r←_Do LOCKSERVER('CltRelease'token)
    ∇

    ∇ r←Init(address port user)
      
      :If 0=⎕NC '##.DRC' ⋄ 'DRC' ##.⎕CY 'conga' ⋄ :EndIf

      :If 0=⊃r←##.DRC.Init''
          {}##.DRC.Close LOCKSERVER←'LockServer'
      :AndIf 0=⊃r←##.DRC.Clt LOCKSERVER address port
          r←_Do LOCKSERVER('CltSetUser'user)
      :Else
          ('Error: ',,⍕r)⎕SIGNAL 11
      :EndIf
    ∇  
    
    ∇ r←Close
      :If r←2=⎕NC 'LOCKSERVER'
         r←##.DRC.Close LOCKSERVER
      :EndIf
    ∇

    ∇ r←Status
     ⍝ Return Lock Demon Status Information
     
      r←⍉↑_Do LOCKSERVER('CltStatus'⍬)
    ∇

    ∇ r←_Do(client cmd);c;done;wr;z
     ⍝ Send a command to Lock Daemon, signal DOMAIN ERROR if it fails
     
      :If 0=1⊃r c←2↑##.DRC.Send client cmd
          :Repeat
              :If ~done←∧/100 0≠1⊃r←##.DRC.Wait c 10000 ⍝ Only wait 10 seconds
     
                  :Select 3⊃r
                  :Case 'Error'
                      done←1
                  :Case 'Progress'
                      ⍝ progress report - update your GUI with 4⊃r?
                      ⎕←'Progress: ',4⊃r
                  :Case 'Receive'
                      :If 0=⊃r
                          r←4⊃r
                      :AndIf 0=⊃r
                          r←2⊃r
                          done←1
                      :Else
                          ('Error: ',,⍕r)⎕SIGNAL 11
                      :EndIf
                  :EndSelect
              :EndIf
          :Until done
      :EndIf
    ∇

:EndNamespace
