﻿:Namespace KF
    (⎕IO ⎕ML ⎕WX)←1 1 3
    FILE←'c:\temp\kftest.dcf'

    ∇ r←{data}IO key;tn;i;KEYS;cn
     ⍝ Keyed File I/O
      :Trap 22
          tn←FILE ⎕FSTIE 0
      :Else
          tn←FILE ⎕FCREATE 0
          ⍬ ⎕FAPPEND tn  ⍝ No keys
          ⎕FUNTIE tn
          FILE ⎕FSTIE tn ⍝ Share tie
      :EndTrap
      
      ⎕FHOLD tn
      :If 0=⎕NC'data' ⍝ Query
          i←(⎕FREAD tn,1)⍳⊂key
          r←⎕FREAD tn,1+i
      :Else ⍝ UpsertDelete
          KEYS←⎕FREAD tn,1
          :If (≢KEYS)≥r←KEYS⍳⊂key ⍝ Key exists
              :If data≡⎕NULL      ⍝ Delete
                  KEYS[r]←¯1↑KEYS
                  (⎕FREAD tn,1+≢KEYS)⎕FREPLACE tn,1+r
                  (¯1↓KEYS)⎕FREPLACE tn,1
                  ⎕FDROP tn,¯1
              :Else               ⍝ Update in place
                  data ⎕FREPLACE tn,1+r
              :EndIf
          :Else                   ⍝ Key does not exist
              :If data≢⎕NULL      ⍝ Delete is a no-op if key does not exist
                  KEYS←KEYS,⊂key
                  KEYS ⎕FREPLACE tn,1
                  ⎕DL 0.01        ⍝ Increase likelihood of trouble!
                  cn←data ⎕FAPPEND tn
              :EndIf
          :EndIf
      :EndIf
      ⎕FUNTIE tn
    ∇

    ∇ Synchronize synch;minwait;now;wait
     ⍝ Synchronize watches
      minwait←5 ⍝ If sync'ing, minimum wait time is 5 to allow everyone a chance
     
      →(synch=0)⍴0
     
      wait←synch×⌈synch÷⍨now←6⊃⎕TS
      wait←wait+synch×minwait>wait-now ⍝ wait an extra cycle if necessary
      ⎕←'Synchronizing... waiting ',(⍕60|wait-now),' seconds...'
      wait←60|wait
      :While wait≠6⊃⎕TS ⋄ ⎕DL 0.05
      :EndWhile
    ∇

    ∇ text←Test ctl;runs;synch;i;key;now;time
      (key runs synch)←3↑ctl,(≢ctl)↓1 100 0
      ⎕←(⍕runs),' runs...'
      ⍝ |   |     \ eg 10 to wait until start of next 10-second period
      ⍝ |   \ number of times to zip round the loop
      ⍝ \ "task" id - used to select distinct set of keys
     
      Synchronize synch    ⍝ All together now
     
      now←⎕AI[3]           ⍝ Start your watches
      text←'Started at ',,'ZI2,<:>,ZI2,<:>,ZI2,<.>,ZI3'⎕FMT 1 4⍴3↓⎕TS
     
      :For i :In ⍳runs
          {}key IO key     ⍝ Create
          :If key≠IO key   ⍝ Verify
              ∘∘∘ ⍝ damage
          :EndIf
          {}key IO key     ⍝ Update
          {}⎕NULL IO key   ⍝ Delete
      :EndFor
     
      time←⎕AI[3]-now
      text,←': ',(⍕runs),' runs with ID ',(⍕key),', elapsed time: ',(3⍕time÷1000)
    ∇

    ∇ text WriteLog LOGFILE;tn
      :Trap 22
          tn←LOGFILE ⎕NTIE 0
      :Else
          tn←LOGFILE ⎕NCREATE 0
      :EndTrap
      (text,⎕UCS 13 10)⎕NAPPEND tn
      ⎕NUNTIE tn
    ∇

    ∇ Boot;getenv;getnum;ID;SYNCH;RUNS;LOGFILE;text
      ⍝ Start a Test if KFTest=id
     
      ⎕←'Command Line:'
      ⎕←2 ⎕NQ'.' 'GetCommandLine'
      getenv←{0=≢r←2 ⎕NQ'.' 'GetEnvironment'⍵:⍺ ⋄ r}
      getnum←{⊃2⊃⎕VFI ⍵}
     
      :If 0≠ID←getnum''getenv'KFTest'
          RUNS←getnum'100'getenv'KFRuns'
          SYNCH←getnum'10'getenv'KFSynch'
          LOGFILE←''getenv'KFLog'
          text←Test ID RUNS SYNCH
          :If 0≠⍴LOGFILE
              text WriteLog LOGFILE
          :EndIf
          ⎕OFF 0
      :EndIf
    ∇

:EndNamespace
